#ifndef __DEVICE_H__
#define __DEVICE_H__

#include <cmath>
extern const char *initSaveDir;

#define BASE_CAPTURE (0x1 << 20)

//
// Capture settings
//
class bbSettings_t {
public:
	enum Timebase {
		AC_COUPLED = 0,
		DC_COUPLED = 1
	};

	bbSettings_t() : center(900.0), gain(2), atten(10), 
		path(initSaveDir), captureTitle(""), captureTrigger(false),
		extTimebase(false), extType(AC_COUPLED),
		decimation(0), bandwidth(27.0), capture_len(BASE_CAPTURE) {}
	bbSettings_t& operator=(const bbSettings_t &other);
	bool operator==(const bbSettings_t &other) const;

	CString path;
	CString captureTitle;

	double center; // MHz
	int gain;      // 0-3
	int atten;     // dB
	bool captureTrigger;
	bool extTimebase;
	int extType;
	int decimation; // [0,8] -> [1,256]
	double bandwidth;

	int capture_len;
};

//
// Settings relating to the view
//
class viewSettings_t {
public:
	viewSettings_t() : refreshRate(25), resolution(10) {}
	viewSettings_t& operator=(const viewSettings_t& other) {
		refreshRate = other.refreshRate;
		resolution = other.resolution;
		return *this;
	}

	int refreshRate;
	int resolution;
};

//
// Signal Stats
//
class signalStats_t {
public:
	signalStats_t() : maxAmp(0.0), avgPower(0.0) {}
	double maxAmp;
	float avgPower;

	//// mode == BB_SEVEN_MHZ or BB_TWENTY_MHZ
	//void Update(short *buf, int len, int mode) {
	//	maxAmp = -1.0;
	//	__int64 sum = 0.0;

	//	if(mode == BB_TWENTY_MHZ) {
	//		for(int i = 0; i < len; i++) {
	//			maxAmp = max(buf[i], maxAmp);
	//			sum += buf[i]*buf[i];
	//		}
	//		rms = sqrt(sum*(1.0/len));

	//	} else { // 7 MHz Math
	//		for(int i = 0; i < len; i++) {
	//			double mag = sqrt((float)((int)buf[i*2]*buf[i*2] + 
	//				(int)buf[i*2+1]*buf[i*2+1]));
	//			maxAmp = max(mag, maxAmp);
	//			sum += (int)(mag*mag);
	//		}
	//		rms = sqrt(sum*(1.0/len));
	//	}
	//}

	void Update(float *buf, int len) {
		double vals[4096];
		double sum = 0.0;
		maxAmp = -10.0;
		for(int i = 0; i < len; i++) {
			double mag = (buf[i*2]*buf[i*2] + buf[i*2+1]*buf[i*2+1])/* / 50.0*/;
			vals[i] = mag;
			maxAmp = max(mag, maxAmp);
			sum += mag;
		}
		sum /= len;
		avgPower = 10.0 * log10(sum);
		maxAmp = 10.0 * log10(maxAmp);
	}
};

//
// Thin wrapper around the BB60 API
//
class bbDevice {
private:

public:
	bbDevice();
	~bbDevice();
	
	bool IsOpen() const { return open; }
	void Open();
	void Close();
	void Configure(const bbSettings_t &s);
	void GetSpectrum(float *buf, int *trigArray);
	
	double GetCenter() const { return realCenter; }
	bbStatus LastStatus() const { return last_status; }

	float cc[2048];

private:
	int collect_count; // Collect enough data so fft fits
	int iq_len;

	bool open;
	int id;
	double realCenter;
	bbStatus last_status;
};

#endif